/* Views entfernen */
IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Ansprechpartner')
BEGIN
	DROP VIEW Cadosys_Ansprechpartner
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Buchungskreis')
BEGIN
	DROP VIEW Cadosys_Buchungskreis
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Kreis')
BEGIN
	DROP VIEW Cadosys_Kreis
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Mandanten')
BEGIN
	DROP VIEW Cadosys_Mandanten
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Mieteinheiten')
BEGIN
	DROP VIEW Cadosys_Mieteinheiten
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Mieter')
BEGIN
	DROP VIEW Cadosys_Mieter
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Objekt')
BEGIN
	DROP VIEW Cadosys_Objekt
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_OrganisationalLevel3')
BEGIN
	DROP VIEW Cadosys_OrganisationalLevel3
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_OrganisationalLevel4')
BEGIN
	DROP VIEW Cadosys_OrganisationalLevel4
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_OrganisationalLevel5')
BEGIN
	DROP VIEW Cadosys_OrganisationalLevel5
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_OrganisationalLevel6')
BEGIN
	DROP VIEW Cadosys_OrganisationalLevel6
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_OrganisationalLevel7')
BEGIN
	DROP VIEW Cadosys_OrganisationalLevel7
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_FirmaOrganisationsebene3')
BEGIN
	DROP VIEW Cadosys_FirmaOrganisationsebene3
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_FirmaOrganisationsebene4')
BEGIN
	DROP VIEW Cadosys_FirmaOrganisationsebene4
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_FirmaOrganisationsebene5')
BEGIN
	DROP VIEW Cadosys_FirmaOrganisationsebene5
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_FirmaOrganisationsebene6')
BEGIN
	DROP VIEW Cadosys_FirmaOrganisationsebene6
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_FirmaOrganisationsebene7')
BEGIN
	DROP VIEW Cadosys_FirmaOrganisationsebene7
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Aktivitaeten')
BEGIN
	DROP VIEW Cadosys_Aktivitaeten
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Kreditoren')
BEGIN
	DROP VIEW Cadosys_Kreditoren
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_DEBITOREN')
BEGIN
	DROP VIEW Cadosys_DEBITOREN
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Steuerschluessel')
BEGIN
	DROP VIEW Cadosys_Steuerschluessel
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Sachkonten')
BEGIN
	DROP VIEW Cadosys_Sachkonten
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_HaushaltsnaheDienstleistungen')
BEGIN
	DROP VIEW Cadosys_HaushaltsnaheDienstleistungen
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_StandardAktivitaeten')
BEGIN
    DROP VIEW Cadosys_StandardAktivitaeten
END

IF EXISTS (SELECT *
		FROM INFORMATION_SCHEMA.VIEWS
		WHERE table_name = 'Cadosys_Aktivitaetstitel')
BEGIN
    DROP VIEW Cadosys_Aktivitaetstitel
END
GO


/* Views anlegen*/

CREATE VIEW [dbo].[Cadosys_HaushaltsnaheDienstleistungen]
AS
SELECT [Schlssel] =		   dbo.TZ0940_PRGParameter.ProgID
	 , [Dienstleistung Text] = dbo.TZ0940_PRGParameter.Wert
	 , [Beschriftung] =		   dbo.TZ0940_PRGParameter.Beschreibung
FROM TZ0940_PRGParameter
WHERE ProgID IN (6059, 6060, 6061, 6062)
GO

CREATE VIEW [dbo].[Cadosys_Sachkonten]
AS
SELECT [Konto] =						dbo.TF0014_Konto.KontoNr
	 , [Beschriftung] =					dbo.TF0014_Konto.KontoText
	 , [Firma Organisationseinheit 3] = dbo.TA0010_Mandant.MandantNr
	 , [Firma Organisationseinheit 4] = dbo.TA0100_Kreis.KreisLFN
	 , [Firma Organisationseinheit 5] = dbo.TA0200_Objekt.ObjektLFN
	 , [Kostenstelle] =					NULL
	 , [Steuerschlssel] =				dbo.TF0003_AllgSteuerCode.AllgSteuerCode
	 , [Suchtexte] =					NULL
	 , [ExportWert] =					dbo.TF0014_Konto.KontoLFN
FROM dbo.TF0014_Konto
LEFT JOIN dbo.TF0003_AllgSteuerCode
	ON TF0003_AllgSteuerCode.AllgSteuerCodeLFN = TF0014_Konto.AllgSteuerCodeLFN
JOIN dbo.TF0012_KontoArt
	ON TF0012_KontoArt.KontoArtLFN = TF0014_Konto.KontoArtLFN
JOIN dbo.TF0010_FibuEbene
	ON dbo.TF0012_KontoArt.FibuEbeneLFN = dbo.TF0010_FibuEbene.FibuEbeneLFN
JOIN dbo.TA0010_Mandant
	ON TF0010_FibuEbene.MandantLFN = dbo.TA0010_Mandant.MandantLFN
LEFT JOIN TA0100_Kreis
	ON KontoKreisLFN = TA0100_Kreis.KreisLFN
LEFT JOIN TA0200_Objekt
	ON KontoObjektLFN = TA0200_Objekt.ObjektLFN
GO

CREATE VIEW [dbo].[Cadosys_Steuerschluessel]
AS
SELECT [Schlssel] =					dbo.TF0003_AllgSteuerCode.AllgSteuerCode
	 , [Beschriftung] =					dbo.TF0003_AllgSteuerCode.AllgSteuerText
	 , [Firma Organisationseinheit 3] = NULL
	 , [Steuersatz] =					dbo.TF0003_AllgSteuerCode.AllgSteuerSatz
	 , [Suchtexte] =					NULL
	 , [ExportWert] =					dbo.TF0003_AllgSteuerCode.AllgSteuerCodeLFN

FROM dbo.TF0003_AllgSteuerCode
GO

CREATE VIEW [dbo].[Cadosys_DEBITOREN]
AS
SELECT [Nummer] =						dbo.TA0160_Adresse.AdresseDebNr
	 , [Nummer 2] =						dbo.TA0160_Adresse.AdressenLFN
	 , [Firma Organisationseinheit 3] = NULL
	 , [Name] =							dbo.TA0160_Adresse.AdressenAlpha
	 , [Strae] =						dbo.TA0160_Adresse.AdressenStr
	 , [PLZ] =							dbo.TA0160_Adresse.AdressenPLZ
	 , [Ort9 =							dbo.TA0160_Adresse.AdressenOrt
	 , [Land] =							dbo.TA0160_Adresse.AdressenLand
	 , [Telefon] =						dbo.vAdressenKommunikation.AdressenTelFirma
	 , [Fax] =							dbo.vAdressenKommunikation.AdressenFax
	 , [Email =							dbo.vAdressenKommunikation.AdressenEMAIL
	 , [UmsatzsteuerId] =				dbo.TA0160_Adresse.AdresseKredUstID
	 , [Steuernummer] =					dbo.TA0160_Adresse.Steuernummer
	 , [IBAN] =							dbo.TA0160_Adresse.IBAN
	 , [Kontonummer] =					dbo.TA0160_Adresse.AdressenKonto
	 , [Bankleitzahl] =					dbo.TA0160_Adresse.AdressenBLZ
	 , [IBAN 2] =						NULL
	 , [Kontonummer 2] =				NULL
	 , [Bankleitzahl 2] =				NULL
	 , [IBAN 3] =						NULL
	 , [Kontonummer 3] =				NULL
	 , [Bankleitzahl 3] =				NULL
	 , [IBAN 4] =						NULL
	 , [Kontonummer 4] =				NULL
	 , [Bankleitzahl 4] =				NULL
	 , [IBAN 5] =						NULL
	 , [Kontonummer 5] =				NULL
	 , [Bankleitzahl 5] =				NULL
	 , [Workflowschritt 1 Benutzer] =   NULL
	 , [Workflowschritt 2 Benutzer] =   NULL
	 , [Workflowschritt 3 Benutzer] =   NULL
	 , [Workflowschritt 4 Benutzer] =   NULL
	 , [Workflowschritt 5 Benutzer] =   NULL
FROM dbo.TA0160_Adresse
LEFT OUTER JOIN dbo.vAdressenKommunikation
	ON dbo.vAdressenKommunikation.AdressenLFN = dbo.TA0160_Adresse.AdressenLFN
WHERE (dbo.TA0160_Adresse.AdresseDebNr IS NOT NULL)
AND (dbo.TA0160_Adresse.AdressenDeb = 1)
AND (dbo.vAdressenKommunikation.AnschriftArtLFN = 0)
AND (1 = 0) /* !! */
GO

CREATE VIEW [dbo].[Cadosys_Kreditoren]
AS
SELECT [Nummer] =						dbo.TA0160_Adresse.AdressenLFN
	 , [Nummer 2] =						dbo.TA0160_Adresse.AdresseKredNr
	 , [Firma Organisationseinheit 3] = NULL
	 , [Name] =							dbo.TA0160_Adresse.AdressenAlpha
	 , [Strae] =						dbo.TA0160_Adresse.AdressenStr
	 , [Ort] =							dbo.TA0160_Adresse.AdressenOrt
	 , [PLZ] =							dbo.TA0160_Adresse.AdressenPLZ
	 , [Land] =							dbo.TA0160_Adresse.AdressenLand
	 , [Telefon] =						dbo.vAdressenKommunikation.AdressenTelFirma
	 , [Fax] =							dbo.vAdressenKommunikation.AdressenFax
	 , [Email] =						dbo.vAdressenKommunikation.AdressenEMAIL
	 , [UmsatzsteuerId] =				dbo.TA0160_Adresse.AdresseKredUstID
	 , [Steuernummer] =					dbo.TA0160_Adresse.Steuernummer
	 , [IBAN] =							dbo.TA0160_Adresse.IBAN
	 , [Kontonummer] =					dbo.TA0160_Adresse.AdressenKonto
	 , [Bankleitzahl] =					dbo.TA0160_Adresse.AdressenBLZ
	 , [IBAN 2] =						NULL
	 , [Kontonummer 2] =				NULL
	 , [Bankleitzahl 2] =				NULL
	 , [IBAN 3] =						NULL
	 , [Kontonummer 3] =				NULL
	 , [Bankleitzahl 3] =				NULL
	 , [IBAN 4] =						NULL
	 , [Kontonummer 4] =				NULL
	 , [Bankleitzahl 4] =				NULL
	 , [IBAN 5] =						NULL
	 , [Kontonummer 5] =				NULL
	 , [Bankleitzahl 5] =				NULL
	 , [Workflowschritt 1 Benutzer] =   NULL
	 , [Workflowschritt 2 Benutzer] =   NULL
	 , [Workflowschritt 3 Benutzer] =   NULL
	 , [Workflowschritt 4 Benutzer] =   NULL
	 , [Workflowschritt 5 Benutzer] =   NULL
FROM dbo.TA0160_Adresse
LEFT OUTER JOIN dbo.vAdressenKommunikation
	ON dbo.vAdressenKommunikation.AdressenLFN = dbo.TA0160_Adresse.AdressenLFN
WHERE (dbo.vAdressenKommunikation.AnschriftArtLFN = 0)
GO

CREATE VIEW [dbo].[Cadosys_Aktivitaeten]
AS
SELECT DISTINCT [Nummer] =						 Navi.tblAktivitaet.AktivitaetNr
			  , [Beschriftung] =				 Navi.tblAktivitaet.AktivitaetBez
			  , [ErstelltAm] =					 Navi.tblAktivitaet.ErstelltAm
			  , [MandantNr] =					 dbo.TA0010_Mandant.MandantNr
			  , [MandantBezeichnung] =			 dbo.TA0010_Mandant.MandantBezeichnung
			  , [KreisNr] =						 dbo.TA0100_Kreis.Kreis
			  , [KreisBezeichnung] =			 dbo.TA0100_Kreis.KreisText
			  , [ObjektNR] =					 dbo.TA0200_Objekt.ObjektNR
			  , [ObjektBezeichnung] =			 dbo.TA0200_Objekt.ObjektBezeichnung
			  , [Einheittext] =					 dbo.TA0310_MietEigEinheit.Einheittext
			  , [MietEigNr] =					 dbo.TA0300_MietEig.MietEigNr
			  , [AdressNr] =					 dbo.TA0160_Adresse.AdressenLFN
			  , [AdresseKredNr] =				 dbo.TA0160_Adresse.AdresseKredNr
			  , [AdresseDebNr] =				 dbo.TA0160_Adresse.AdresseDebNr
			  , [MietEigAdressenvName] =		 MietEigAdresse.AdressenvName1
			  , [MietEigAdressenName] =			 MietEigAdresse.AdressenName1
			  , [AdressenvName1] =				 dbo.TA0160_Adresse.AdressenvName1
			  , [AdressenName1] =				 dbo.TA0160_Adresse.AdressenName1
			  , [AktivitaetStatus] =			 Navi.dicStatus.[Status]
			  , [Firma Organisationseinheit 3] = dbo.TA0010_Mandant.MandantNr
			  , [Firma Organisationseinheit 4] = dbo.TA0100_Kreis.KreisLFN
			  , [Firma Organisationseinheit 5] = dbo.TA0200_Objekt.ObjektLFN
			  , [Firma Organisationseinheit 6] = dbo.TA0310_MietEigEinheit.EinheitLFN
			  , [Firma Organisationseinheit 7] = dbo.TA0300_MietEig.MietEigLFN
FROM Navi.tblAktivitaet
INNER JOIN Navi.tblKontakt
	ON Navi.tblAktivitaet.AktivitaetId = Navi.tblKontakt.AktivitaetId
INNER JOIN Navi.tblAktivitaetZuordnung
	ON Navi.tblAktivitaet.AktivitaetId = Navi.tblAktivitaetZuordnung.AktivitaetId
INNER JOIN Navi.dicStatus
	ON Navi.tblKontakt.KontaktStatusId = Navi.dicStatus.StatusId
LEFT OUTER JOIN dbo.TA0010_Mandant
	ON Navi.tblAktivitaetZuordnung.MandantLFN = dbo.TA0010_Mandant.MandantLFN
LEFT OUTER JOIN dbo.TA0100_Kreis
	ON Navi.tblAktivitaetZuordnung.KreisLFN = dbo.TA0100_Kreis.KreisLFN
LEFT OUTER JOIN dbo.TA0200_Objekt
	ON Navi.tblAktivitaetZuordnung.ObjektLFN = dbo.TA0200_Objekt.ObjektLFN
LEFT OUTER JOIN dbo.TA0310_MietEigEinheit
	ON Navi.tblAktivitaetZuordnung.EinheitLFN = dbo.TA0310_MietEigEinheit.EinheitLFN
LEFT OUTER JOIN dbo.TA0300_MietEig
	ON Navi.tblAktivitaetZuordnung.MietEigLFN = dbo.TA0300_MietEig.MietEigLFN
LEFT OUTER JOIN dbo.TA0160_Adresse AS MietEigAdresse
	ON dbo.TA0300_MietEig.AdressenLFN = MietEigAdresse.AdressenLFN
LEFT OUTER JOIN dbo.TA0160_Adresse
	ON Navi.tblAktivitaetZuordnung.AdressenLFN = dbo.TA0160_Adresse.AdressenLFN
WHERE (Navi.tblKontakt.KontaktNr = 0)
AND (Navi.tblAktivitaet.IsDeleted = 0)
AND (Navi.dicStatus.StatusTyp <> 5)
AND (dbo.TA0200_Objekt.ObjektVerwaltungsende > GETDATE()
OR dbo.TA0200_Objekt.ObjektVerwaltungsende IS NULL)
GO

CREATE VIEW [dbo].Cadosys_FirmaOrganisationsebene3
AS
SELECT [Nummer] =						dbo.TA0010_Mandant.MandantNr
	 , [Nummer 2] =						dbo.TA0010_Mandant.MandantLFN
	 , [Firma Organisationseinheit 3] = dbo.TA0010_Mandant.MandantNr
	 , [Beschriftung] =					dbo.TA0010_Mandant.MandantAlpha
	 , [Firma] =						dbo.TA0010_Mandant.MandantBezeichnung
	 , [Anrede] =						dbo.TA0160_Adresse.AdressenAnschrift
	 , [Titel] =						dbo.TZ0916_Titel.Titel
	 , [Vorname] =						dbo.TA0160_Adresse.AdressenvName1
	 , [Nachname] =						dbo.TA0160_Adresse.AdressenName1
	 , [Strae] =						dbo.TA0160_Adresse.AdressenStr
	 , [PLZ] =							dbo.TA0160_Adresse.AdressenPLZ
	 , [Ort] =							dbo.TA0160_Adresse.AdressenOrt
	 , [Land] =							dbo.TA0160_Adresse.AdressenLand
	 , [Email] =						dbo.TA0160_Adresse.AdressenEMAIL
	 , [UmsatzsteuerId] =				dbo.TA0160_Adresse.AdresseKredUstID
	 , [Steuernummer] =					dbo.TA0160_Adresse.Steuernummer
	 , [IBAN] =							dbo.TA0160_Adresse.IBAN
	 , [Kontonummer] =					dbo.TA0160_Adresse.AdressenKonto
	 , [Bankleitzahl] =					dbo.TA0160_Adresse.BicSWift
	 , [IBAN 2] =						NULL
	 , [Kontonummer 2] =				NULL
	 , [Bankleitzahl 2] =				NULL
	 , [IBAN 3] =						NULL
	 , [Kontonummer 3] =				NULL
	 , [Bankleitzahl 3] =				NULL
	 , [IBAN 4] =						NULL
	 , [Kontonummer 4] =				NULL
	 , [Bankleitzahl 4] =				NULL
	 , [IBAN 5] =						NULL
	 , [Kontonummer 5] =				NULL
	 , [Bankleitzahl 5] =				NULL
FROM dbo.TA0010_Mandant
LEFT JOIN (SELECT FibuEbeneLFN
				, MandantLFN
	FROM dbo.TF0010_FibuEbene
	WHERE TF0010_FibuEbene.KreisLFN = 0
	AND TF0010_FibuEbene.ObjektLFN = 0) FibuEbene
	ON FibuEbene.MandantLFN = TA0010_Mandant.MandantLFN
LEFT JOIN dbo.TA0160_Adresse
	ON dbo.TA0160_Adresse.AdressenLFN = TA0010_Mandant.AdressenLFN
LEFT JOIN TZ0916_Titel
	ON dbo.TA0160_Adresse.AdressenTitel1LFN = dbo.TZ0916_Titel.TitelLFN
GO

CREATE VIEW [dbo].[Cadosys_FirmaOrganisationsebene4]
AS
SELECT [Nummer] =						dbo.TA0100_Kreis.Kreis
	 , [Firma Organisationseinheit 3] = dbo.TA0010_Mandant.MandantNr
	 , [Firma Organisationseinheit 4] = dbo.TA0100_Kreis.KreisLFN
	 , [Beschriftung] =					dbo.TA0100_Kreis.KreisBeschreibung
	 , [Firma] =						dbo.TA0100_Kreis.KreisText
	 , [Anrede] =						dbo.TA0160_Adresse.AdressenAnschrift
	 , [Titel] =						dbo.TZ0916_Titel.Titel
	 , [Vorname] =						dbo.TA0160_Adresse.AdressenvName1
	 , [Nachname] =						dbo.TA0160_Adresse.AdressenName1
	 , [Strae] =						dbo.TA0160_Adresse.AdressenStr
	 , [PLZ] =							dbo.TA0160_Adresse.AdressenPLZ
	 , [Ort] =							dbo.TA0160_Adresse.AdressenOrt
	 , [Land] =							dbo.TA0160_Adresse.AdressenLand
	 , [Email] =						dbo.TA0160_Adresse.AdressenEMAIL
FROM dbo.TA0100_Kreis
JOIN dbo.TA0010_Mandant
	ON TA0100_Kreis.MandantLFN = dbo.TA0010_Mandant.MandantLFN
LEFT JOIN (SELECT FibuEbeneLFN
				, KreisLFN
	FROM dbo.TF0010_FibuEbene
	WHERE dbo.TF0010_FibuEbene.ObjektLFN = 0) FibuEbene
	ON FibuEbene.KreisLFN = TA0100_Kreis.KreisLFN
LEFT JOIN dbo.TA0160_Adresse
	ON dbo.TA0100_Kreis.AdressenLFN = dbo.TA0160_Adresse.AdressenLFN
LEFT JOIN dbo.TZ0916_Titel
	ON dbo.TA0160_Adresse.AdressenTitel1LFN = dbo.TZ0916_Titel.TitelLFN
GO

CREATE VIEW [dbo].[Cadosys_FirmaOrganisationsebene5]
AS
SELECT [Nummer] =						dbo.TA0200_Objekt.ObjektNr
	 , [Firma Organisationseinheit 3] = dbo.TA0010_Mandant.MandantNr
	 , [Firma Organisationseinheit 4] = dbo.TA0100_Kreis.KreisLFN
	 , [Firma Organisationseinheit 5] = dbo.TA0200_Objekt.ObjektLFN
	 , [Beschriftung] =					dbo.TA0200_Objekt.ObjektAlpha
	 , [Firma] =						dbo.TA0200_Objekt.ObjektBezeichnung
	 , [Anrede] =						NULL
	 , [Titel] =						NULL
	 , [Vorname] =						NULL
	 , [Nachname] =						NULL
	 , [Strae] =						dbo.TA0200_Objekt.ObjektStr
	 , [PLZ] =							dbo.TA0200_Objekt.ObjektPlz
	 , [Ort] =							dbo.TA0200_Objekt.ObjektOrt
	 , [Land] =							dbo.TA0200_Objekt.ObjektLand
	 , [Email] =						NULL
FROM dbo.TA0200_Objekt
INNER JOIN dbo.TA0100_Kreis
	ON dbo.TA0100_Kreis.KreisLFN = dbo.TA0200_Objekt.KreisLFN
INNER JOIN dbo.TA0010_Mandant
	ON dbo.TA0010_Mandant.MandantLFN = dbo.TA0100_Kreis.MandantLFN
LEFT JOIN (SELECT FibuEbeneLFN
				, ObjektLFN
	FROM dbo.TF0010_FibuEbene) FibuEbene
	ON FibuEbene.ObjektLFN = dbo.TA0200_Objekt.ObjektLFN
WHERE dbo.TA0200_Objekt.ObjektVerwaltungsende > GETDATE()
OR dbo.TA0200_Objekt.ObjektVerwaltungsende IS NULL
GO

CREATE VIEW [dbo].[Cadosys_FirmaOrganisationsebene6]
AS
SELECT [Nummer] =						dbo.TA0310_MietEigEinheit.EinheitLFN
	 , [Firma Organisationseinheit 3] = dbo.TA0010_Mandant.MandantNr
	 , [Firma Organisationseinheit 4] = dbo.TA0100_Kreis.KreisLFN
	 , [Firma Organisationseinheit 5] = dbo.TA0200_Objekt.ObjektLFN
	 , [Firma Organisationseinheit 6] = dbo.TA0310_MietEigEinheit.EinheitLFN
	 , [Beschriftung] =					dbo.TA0310_MietEigEinheit.Einheittext
	 , [Firma] =						NULL
	 , [Anrede] =						NULL
	 , [Titel] =						NULL
	 , [Vorname] =						NULL
	 , [Nachname] =						NULL
	 , [Strae] =						NULL
	 , [PLZ] =							NULL
	 , [Ort] =							NULL
	 , [Land] =							NULL
	 , [Email] =						NULL
FROM dbo.TA0310_MietEigEinheit
INNER JOIN dbo.TA0200_Objekt
	ON TA0200_Objekt.ObjektLFN = TA0310_MietEigEinheit.ObjektLFN
INNER JOIN dbo.TA0100_Kreis
	ON TA0100_Kreis.KreisLFN = TA0200_Objekt.KreisLFN
INNER JOIN dbo.TA0010_Mandant
	ON TA0010_Mandant.MandantLFN = TA0100_Kreis.MandantLFN
GO

CREATE VIEW [dbo].[Cadosys_FirmaOrganisationsebene7]
AS
SELECT [Nummer] =						dbo.TA0300_MietEig.MietEigNr
	 , [Firma Organisationseinheit 3] = dbo.TA0010_Mandant.MandantNr
	 , [Firma Organisationseinheit 4] = dbo.TA0100_Kreis.KreisLFN
	 , [Firma Organisationseinheit 5] = dbo.TA0200_Objekt.ObjektLFN
	 , [Firma Organisationseinheit 6] = dbo.TA0310_MietEigEinheit.EinheitLFN
	 , [Firma Organisationseinheit 7] = dbo.TA0300_MietEig.MietEigLFN
	 , [Beschriftung] =					(dbo.TA0160_Adresse.AdressenvName1 + ' ' + dbo.TA0160_Adresse.AdressenName1)
	 , [Firma] =						NULL
	 , [Anrede] =						dbo.TA0160_Adresse.AdressenAnschrift
	 , [Titel] =						dbo.TZ0916_Titel.Titel
	 , [Vorname] =						dbo.TA0160_Adresse.AdressenvName1
	 , [Nachname] =						dbo.TA0160_Adresse.AdressenName1
	 , [Strae] =						dbo.TA0160_Adresse.AdressenStr
	 , [PLZ] =							dbo.TA0160_Adresse.AdressenPLZ
	 , [Ort] =							dbo.TA0160_Adresse.AdressenOrt
	 , [Land] =							dbo.TA0160_Adresse.AdressenLand
	 , [Email] =						dbo.TA0160_Adresse.AdressenEMAIL
FROM dbo.TA0300_MietEig
INNER JOIN dbo.TA0310_MietEigEinheit
	ON TA0300_MietEig.EinheitLFN = TA0310_MietEigEinheit.EinheitLFN
INNER JOIN dbo.TA0200_Objekt
	ON TA0200_Objekt.ObjektLFN = TA0310_MietEigEinheit.ObjektLFN
INNER JOIN dbo.TA0100_Kreis
	ON TA0100_Kreis.KreisLFN = TA0200_Objekt.KreisLFN
INNER JOIN dbo.TA0010_Mandant
	ON TA0010_Mandant.MandantLFN = TA0100_Kreis.MandantLFN
JOIN dbo.TA0160_Adresse
	ON dbo.TA0160_Adresse.AdressenLFN = TA0300_MietEig.AdressenLFN
LEFT JOIN dbo.TZ0916_Titel
	ON dbo.TA0160_Adresse.AdressenTitel1LFN = dbo.TZ0916_Titel.TitelLFN
GO

CREATE VIEW [dbo].[Cadosys_StandardAktivitaeten]
AS
SELECT CAST(tblAktivitaet.AktivitaetId AS VARCHAR(36)) AktivitaetId
     , tblAktivitaet.AktivitaetBez
     , tblAktivitaet.ErstelltVon
     , CAST(tblKategorie.KategorieId AS VARCHAR(36))   KategorieId
     , tblKategorie.KategorieBez
FROM Navi.tblAktivitaet
         INNER JOIN Navi.tblKategorie
                    ON tblKategorie.KategorieId = tblAktivitaet.KategorieId
WHERE tblAktivitaet.IsDeleted = 0
  AND tblAktivitaet.AktivitaetNr = 0
  AND tblAktivitaet.IsStandard = 1
GO

CREATE VIEW [dbo].[Cadosys_Aktivitaetstitel]
AS
SELECT sub.Beschriftung, COUNT(sub.Nummer) AS Anzahl
FROM (SELECT Nummer, Beschriftung FROM dbo.Cadosys_Aktivitaeten GROUP BY Nummer, Beschriftung) AS sub
GROUP BY sub.Beschriftung
GO